//Exp 5.2 Program Title:Image Enhancement using neighbourhood processing Median filtering 
//environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
im1=imread(SIVP_PATH + 'images/rose1.bmp');//read  color image from directory
im2=rgb2gray(im1);//grayscale image
im3=imnoise(im2,'salt & pepper',0.2);//adding salt & pepper noise in image
[r,c]=size(im3); 
for i=2:1:r-1
      for j=2:1:c-1
         a=[im3(i-1,j-1),im3(i-1,j),im3(i-1,j+1),...
            im3(i,j-1),im3(i,j),im3(i,j+1),...
            im3(i+1,j-1),im3(i+1,j),im3(i+1,j+1)];
         m=gsort(a); //sorting the elements of a in ascending order ; 
             av1(i,j)=m(5);//select median value 
      end
end
figure(1);ShowColorImage(im1,'Color Image');title('Color Image','color','red','fontsize',6);//IPD Toolbox
figure(2);ShowImage(im2,'Grayscale Image');title('Grayscale Image','color','red','fontsize',6);//IPD Toolbox
figure(3);ShowImage(im3,'Salt and Pepper noise Image');title('Salt and Pepper noise Image','color','red','fontsize',6);//IPD Toolbox
figure(4);ShowImage(av1,'Median Filtered Image');title('Median Filtered Image','color','red','fontsize',6);//IPD Toolbox

